<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

	<xsl:template name="TerminationDrp"><link href="style.css" rel="stylesheet" type="text/css" />
		
		<xsl:for-each
			select="n2:drpInfo/ns4:terminationDisclosure/ns4:terminationDrp">
			<div id="maiDRPterm">
				<div class="contentwrapper">
					<h1><u>TERMINATION DISCLOSURE REPORTING PAGE (MA-I)</u></h1>
					<h1>TERMINATION DISCLOSURE DRP PART 1</h1>
					<p>
						This <strong>Disclosure Reporting Page (DRP MA-I)</strong> is an
						<strong>
							<xsl:choose>
								<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:add) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							INITIAL </strong> or
							<strong><xsl:choose>
								<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							AMENDED 
						</strong>
						response to report details for affirmative response(s) to
						<strong><em> Question 6J</em></strong> on Form MA-I.
					</p>
					<p>Check the question(s) to which this DRP pertains:</p>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdThreeCol">
								<strong style="margin-left: 10px;">
									<xsl:choose>
										<xsl:when test="ns4:terminationQuestions='6J(1)'">
											<img src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6J(1)
								</strong>
							</div>
							<div class="tdStyle1 tdThreeCol">
								<strong style="margin-left: 10px;">
									<xsl:choose>
										<xsl:when test="ns4:terminationQuestions='6J(2)'">
											<img src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6J(2)
								</strong>
							</div>
							<div class="tdStyle1 tdThreeCol">
								<strong style="margin-left: 10px;">
									<xsl:choose>
										<xsl:when test="ns4:terminationQuestions='6J(3)'">
											<img src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6J(3)
								</strong>
							</div>
						</div><div style="clear:both"></div>
					</div>
	
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div>
					<div class="tdStyle1 tditem10col1">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the individual from the record?
					</div>
					<div class="tdStyle1 tditem10col2">
						<xsl:choose>
						<xsl:when
							test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'Y'">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						</xsl:choose>    
						YES<xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'N'">
										<img
									src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
							 <img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								
							</xsl:otherwise>
						</xsl:choose>    
						NO
					</div>
				</div><div style="clear:both"></div>
			</div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div class="tableRow">
						<div class="tdStyle1">
							If &quot;Yes,&quot; the reason the DRP should be removed is:
						</div>						
					</div><div style="clear:both"></div>
				</div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div class="tableRow">	
						<p>					
						<xsl:choose>
								<xsl:when
								test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered) &gt; 0">
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>

								<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
						</xsl:choose>				         
						The event or <em>proceeding</em> was resolved in the individual&#39;s favor<br />
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError) &gt; 0">
									 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>    
						The DRP was filed in error. </p>
					</div><div style="clear:both"></div>
				</div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div class="tableRow">
						<div class="tdStyle1">
							<br />
					              Explain the circumstances:<br></br>
					        <textarea name="textarea4" style="margin-left: 100px;" id="textarea4" cols="52" rows="5">
								<xsl:value-of
								select=				"string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />		
					        </textarea>
						</div>						
					</div><div style="clear:both"></div>
				</div>
				<p>
					<strong>
						<u>How to Report a Termination on a Termination DRP:</u>
					</strong>
					One termination may result in more than one affirmative answer to
					the above items. Use only one Termination DRP to report details
					about the same termination. Use a separate Termination DRP for
					each termination reported.
				</p>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div>
						<div class="tdStyle1 tditem10col1">
							<strong>
									<u>DRP on File for This Event:</u></strong>								
								<u>Is an accurate and up-to-date DRP containing the information
								regarding the individual required by this DRP already on file (a)
								in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, 
								or U4), or (b) in the <em>SEC's</em> EDGAR system (with a Form MA or 
								Form MA-I)?</u>
						</div>
						<div class="tdStyle1 tditem10col2">
							<xsl:choose>
								<xsl:when test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling or ns4:baseHeader/ns4:filingInfo/ns4:maFiling or ns4:baseHeader/ns4:filingInfo/ns4:matFiling or ns4:baseHeader/ns4:filingInfo/ns4:maiFiling">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Yes
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									No
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Yes
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									No
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div><div style="clear:both"></div>
				</div>
										
				<p>
				<em><u>

					Note: The filer may identify a DRP filed by the
					individual directly, or filed by another SEC registrant about the
					individual as an associated person.

				</u></em>
				</p>
					<br></br>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1">
								<p>
									Provide the applicable information indicated below that identifies where the DRP may be found.								
								</p>
							</div>							
						</div><div style="clear:both"></div>
					</div>
					<br></br>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">						
								<xsl:choose>
                                    <xsl:when
                                        test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName">

                                        <img src="Images/box-checked.jpg" alt="checkbox checked" />
                                    </xsl:when>
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                </xsl:choose>
								<strong> 1. Form ADV, BD, or U4 Filing:
								For a DRP filed on the <em>IARD</em> or <em>CRD</em>
								system with one of these forms, provide the following
								information:
								</strong>
							</div>
							
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name on Registration:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of
									   select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p><em>CRD</em> No.:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Disclosure Occurrence No:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber" />
							</div>
						</div><div style="clear:both"></div>
					</div>
					
						<div class="tableRow">
							<div class="tdStyle1">					
								<xsl:choose>
									<xsl:when test="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<strong> 2. Form MA Filing: </strong>
								For a DRP filed on EDGAR with a Form MA, provide the following information:
							</div>							
						</div><div style="clear:both"></div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name on Registration:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>MA Registration Number:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Accession number of the filing:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber" />
							</div>
						</div><div style="clear:both"></div>
					</div>
					
						<div class="tableRow">
							<div class="tdStyle1">						
								<xsl:choose>
                                    <xsl:when
                                        test="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName">

                                        <img src="Images/box-checked.jpg" alt="checkbox checked" />
                                    </xsl:when>
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                </xsl:choose>
								<strong> 3. Form MA-I Filing:</strong>
								For a DRP filed on EDGAR with a Form MA-I, provide the following information:
							</div>							
						</div><div style="clear:both"></div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name of Individual: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>MA-I File Number:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Accession number of the filing:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber" />
							</div>
						</div><div style="clear:both"></div>
					</div>				
					<p class="guidance">
						<strong>NOTE:
						The completion of all or any part of this form does not relieve
						the individual or any <em>municipal advisor</em> with which it is
						associated of the obligation to update any relevant Form MA or 
						<em>IARD</em> or <em>CRD</em> records.
						</strong>
					</p>				
					 <h1>TERMINATION DISCLOSURE DRP PART 2</h1>
					 <div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>1. Name of Employing Firm:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:drpData/ns4:firmInfo/ns4:name" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>
									<strong>MA Registration Number, if any:</strong>
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:drpData/ns4:firmInfo/ns4:registrationNumber" />
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>
									<strong> <em>CRD</em> Number, if any:</strong>
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:drpData/ns4:firmInfo/ns4:crdNumber" />
							</div>
						</div><div style="clear:both"></div>
					
						<div>
							<div class="tdStyle1">
								<strong>2. Termination Type:</strong>
								
							</div>
							<div class="tdStyle1">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:terminationType='Discharged'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
										Discharged
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										Discharged
									</xsl:otherwise>
								</xsl:choose>
							</div>											
							<div class="tdStyle1">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:terminationType='Permited to Resign'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
										Permitted to <em>Resign</em>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										Permitted to <em>Resign</em>
									</xsl:otherwise>
								</xsl:choose>								
							</div>							
							<div class="tdStyle1">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:terminationType='Voluntary Resignation'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
										Voluntary <em>Resignation</em>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										Voluntary <em>Resignation</em>
									</xsl:otherwise>
								</xsl:choose>								
							</div>
														
						</div>
					</div>
					<BR></BR>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>3. Termination Date (MM/DD/YYYY):</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
								<xsl:value-of select="ns4:drpData/ns4:terminationDate/m1:date"/>
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p></p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:terminationDate/m1:exact) &gt; 0">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>Exact
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:terminationDate/m1:explanationInfo/m1:explanation) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>Explanation
							</div>
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>If not exact, provide explanation:</p>
							</div>
							<div></div>							
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol2TextboxNoMargin">
								<xsl:value-of
					                   select="string(ns4:drpData/ns4:terminationDate/m1:explanationInfo/m1:provideExplanation)" />
							</div>							
						</div><div style="clear:both"></div>
					</div>
					 <BR></BR>
					 <div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>4. Allegation(s):</strong>
							</div>							
						</div><div style="clear:both"></div>
					
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol2TextboxNoMargin">
								<xsl:value-of
					                   select="string(ns4:drpData/ns4:allegation)" />
							</div>							
						</div><div style="clear:both"></div>
					</div>
					 <BR></BR>
					 
						<div class="tableRow">
							<div class="tdStyle1">
								<strong>5. Product Type(s): </strong>(Select all that apply.)
							</div>							
						</div><div style="clear:both"></div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='No Product'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								No Product
							</div>
							<div class="tdStyle1 tdThreeCol">
								<p></p>
							</div>
							<div class="tdStyle1 tdThreeCol">
								<p></p>
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='AnnuityCharitable'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity-Charitable
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Direct Investment(s) - DPP &amp; LP Interest(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Direct Investment-DPP &amp; LP Interest
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='OilAndGas'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Oil &amp; Gas
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Annuity(ies) - Fixed'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity-Fixed
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='EquipmentLeasing'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equipment Leasing
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='EquipmentLeasing'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Options
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Annuity(ies) - Variable'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity-Variable
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Equity Listed (Common &amp; Preferred Stock)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equity Listed (Common &amp; Preferred Stock)
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Penny Sock(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Penny Stock
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='BankingProduct'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Banking Product (other than CD)
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Equity - OTC'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equity-OTC
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='PrimeBankInstrument'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Prime Bank Instrument
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='CD(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								CD
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Futures - Commodity'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Futures-Commodity
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Promissory Note'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Promissory Note
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Commodity Option(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Commodity Option
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Futures - Financial'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Futures-Financial
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Real Estate Security'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Real Estate Security
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Debt - Asset Backed'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt-Asset Backed
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Index Option(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Index Option
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Security Futures'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Security Futures
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Debt - Corporate'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt-Corporate
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Insurance'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Insurance
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Security-based Swap'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Security-based Swap
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Debt - Corporate'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt-Corporate
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Insurance'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Insurance
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Security-based Swap'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Security-based Swap
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Debt - Government'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt-Government
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Investment Contract(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Investment Contract
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Swap'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Swap
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Derivative(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Derivative
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Money Market Fund(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Money Market Fund
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Unit Investment Trust(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Unit Investment Trust
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Debt - Municipal'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt-Municipal
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Mutual Fund(s)'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Mutual Fund
							</div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Viatical Settlement'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Viatical Settlement
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:productType/ns4:product='Other'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose><strong>
								Other Product Type:
								</strong>
							</div>
							<div class="tdStyle1 tdThreeCol">&#160;								
							</div>
							<div class="tdStyle1 tdThreeCol">&#160;								
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdThreeCol">
								(specify)
							</div>
							<div class="tdStyle1 tdThreeCol">&#160;								
							</div>
							<div class="tdStyle1 tdThreeCol">&#160;							
							</div>							
						</div><div style="clear:both"></div>
						<div>						
							<div class="tdTwoCol2TextboxNoMargin">
								<xsl:value-of
										   select="string(ns4:drpData/ns4:productType/ns4:productOther)" />
							</div>														
						</div><div style="clear:both"></div>
					</div>
					
					<br></br>
					
						<div class="tableRow">
							<div class="tdStyle1">
								<strong>6. Summary of Circumstances (Optional):</strong>
								<p>
									You may use this space to provide a brief summary of the
									circumstances leading to the termination, including any 
									other relevant information. The information must fit within 
									the space provided.
								</p>
							</div>
						</div><div style="clear:both"></div>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
							<div class="tdStyle1 tdTwoCol2TextboxNoMargin">
								<xsl:value-of
								select="string(ns4:baseHeader/ns4:summary)" />
							</div>	
					</div>
					
					
						
				</div>
			</div>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>